#include <HT66F019.H>
#include "mcu.h"

#include "string.h"
#include "main.h"
#include "timer.h"
#include "button.h"
#include "rf_ap.h"
#include "EEPROM.h"

bit	timer8ms;
/*bit	timer2ms; */
bit	SystemSleep;
bit	ItemForciblyStop;
bit	KeyPress;
bit WaitSend;

u8	button_change;
u8	key_status;
u8	time_period1;
u8  time_period2;
extern u16	timeout_cnt;

irq_t irq_v;
u8 Catch;
u8 TXMacAddress[6];
u8 RXMacAddress[6];
u8 RxData[31];
u8 timeoutperiod;

uc8 ble_adv_pdu[]=
{	
	/* flag */	
	2,0x01,0x06,
	/* Manufacturer Specific Data */	
	17,0x07,'B','e','a','c','o','n',0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xB0,0x01,
	/* complete local name */
	7,0x09,'B','e','a','c','o','n'
};

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void main(void)
{  
	u8	x, flag, cnt,Rxchannel;
	l2_state_t	reg;	
	SystemClock_Configure();
	GIO_Init();
	Clr_RAM();
	BTN_InterfaceConfigure();
	timebase0_configure(); 
	BC7262_inital();				
	SystemSleep = FALSE;
	KeyPress    = FALSE;
	LED1_OFF;
	LED2_OFF;
	LED3_OFF;
	_emi = TRUE;
	TXMacAddress[0]=0x31;
	TXMacAddress[1]=0x32;
	TXMacAddress[2]=0x33;
	TXMacAddress[3]=0x34;
	TXMacAddress[4]=0x35;
	TXMacAddress[5]=0x36;
	Rxchannel = 0x01;
	NoConnRX(Rxchannel);
MainLoop:
	while(1)
	{
		GCC_CLRWDT();
		if(timer8ms)
		{
			timer8ms = FALSE;
			button_change = BTN_ScanStatus();
			if(rf_mode()==RX_MODE)
			{
			  if(timeoutperiod!=0)
			  {
			     timeoutperiod--;	
			  }
			  else
			  {
			     LED1_OFF;
			     LED2_OFF;
			     LED3_OFF;
			  }
			}
			
		}
		
        if(!BC7262STS)
		{
			if(GetPorFlag())
			BC7262_inital();
			irq_v = BC7262_ClrIrq();
			switch(rf_mode())
			{
				case TX_MODE:
					if(irq_v.bits.irq_l2tx)
					{
					   irq_v.bits.irq_l2tx = 0;
					   if(!key_status)
					   {
					   	timeoutperiod = 100;
					   	if(Rxchannel*2<8)Rxchannel = Rxchannel*2;
					    else Rxchannel = 1;	
					   	NoConnRX(Rxchannel);
					   }				   
					}
					break;
									
				case RX_MODE:
					if(irq_v.bits.irq_l2rx)
					{
						GCC_CLRWDT();
						irq_v.bits.irq_l2rx = 0;
						Catch = ReadRxData(RxData);																
						if(Catch)
						{
						  Catch = FALSE;
						  if(RxData[19]==0xB1 || RxData[19]==0xB0)//From app or demo board
						  {
						  	timeoutperiod = 100;
						  	if((RxData[20] & 0x01)==0x01)	LED1_ON;
			                if((RxData[20] & 0x02)==0x02)	LED2_ON;
			                if((RxData[20] & 0x04)==0x04)	LED3_ON;
			                if(RxData[20] ==0x00)
			                {
			                   LED1_OFF;
			                   LED2_OFF;
			                   LED3_OFF;
			                }	
						  }					  
						}   	
					}
					if(Rxchannel*2<8)Rxchannel = Rxchannel*2;
					else Rxchannel = 1;	
					NoConnRX(Rxchannel);							
					break;
										
				default:
				    break;
				  
			}
		}
			
		//---------------------------//
		x = button_change & 0x80;
		if(x)
		{
			button_change &= ~0x80;
			key_status = BTN_GetStatus();
			LED1_OFF;
		    LED2_OFF;
			LED3_OFF;
			if(key_status)                                                                                                                                                     
			{

				KeyPress = TRUE;
				WaitSend = TRUE;
			}			
			else if(key_status == 0x00)
			{
			    KeyPress = FALSE;
			    WaitSend = TRUE;
			}
						
		}
		
		if((!BC7262STS) && WaitSend)
		{
			if((key_status & 0x01)==0x01)	LED1_ON;
			if((key_status & 0x02)==0x02)	LED2_ON;
			if((key_status & 0x04)==0x04)	LED3_ON;
			WaitSend = FALSE;	
			timeout_cnt=0;
			_cton = FALSE;
			KeyPress = FALSE;
			if(GetPorFlag())
			BC7262_inital();	
		    irq_v = BC7262_ClrIrq();
		    if(irq_v.bits.irq_l2rx)
			{
			  irq_v.bits.irq_l2rx = 0;	
			}
		    if(irq_v.bits.irq_l2tx)
		    {
			  irq_v.bits.irq_l2tx = 0;		
		    }
			BeaconSend(key_status,TXMacAddress,sizeof(ble_adv_pdu), (u8 *)ble_adv_pdu);
		}			
	}	
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void MCU_Sleep0(void)     //kokutou 20190915
{
	GCC_CLRWDT();
	_tbon = FALSE;
	_emi  = FALSE;
	_idlen = FALSE;
	_lvden = FALSE;
	_wdtc  = 0xA8;
	GCC_HALT();	
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void Clr_RAM(void)
{
	_bp = 0;
	for(_mp0=0; _mp0<2; _mp0++)
	{
		_mp1 = 0x80;
		for(_tblp=0; _tblp<0x80; _tblp++)
		{
			_iar1 = 0x00;
			_mp1++;
		}
		_bp++;	
	}
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void	GIO_Init(void)
{
	_pac  = 0x77;		//PA7=LED	
	_pa   = 0x7F;		//
	_papu = 0x7F;		//
	
	_pbpu = 0xFF;
	_pcc  = 0xFF;
	_pcpu = 0xFF;
	
	
	_pbc3 = 0;			//LED
	_pbc4 = 0;			//LED
	_pb3 = 0;
	_pb4 = 0;
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void SystemClock_Configure(void)
{   
	_wdtc = 0x57;	
	_csel = 0;
	_csen = 0;
	_cos = 1;

	/* High Frequency clock = HXT (FHS=1) */	
	/* Low Frequency clock = LXT (FSS=1)*/
	/* High Frequency oscillator control enable(FHIDEN=1) */
	/* Low Frequency oscillator control enable (FSIDEN=1) */
	/* system clock = FH */
#if (SYSTEM_CLOCK == 0)			/* for 4MHZ */
	_smod = 0xE0;				/* system clock = HIRC/2 */
	_nop();
	_nop();
#endif	

#if (SYSTEM_CLOCK == 1)			/* for 8MHZ */
	_smod = 0x01;				/* system clock = HIRX */
	_nop();
	_nop();
#endif	

#if (SYSTEM_CLOCK == 2)			/* for 12MHZ */
	_smod = 0x01;				/* system clock = HIRX */
	_nop();
	_nop();
#endif	
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
